import jwt from 'jsonwebtoken';
const JWT_SECRET_RAW = process.env.JWT_SECRET || 'dev-secret';
const JWT_EXPIRES_RAW = process.env.JWT_EXPIRES || '7d';
const JWT_SECRET = JWT_SECRET_RAW;
// jsonwebtoken v9 types use a stricter StringValue for expiresIn; cast env string
const JWT_EXPIRES = JWT_EXPIRES_RAW;
export function signJwt(payload) {
    const options = { expiresIn: JWT_EXPIRES };
    return jwt.sign(payload, JWT_SECRET, options);
}
export function verifyJwt(token) {
    try {
        return jwt.verify(token, JWT_SECRET);
    }
    catch {
        return null;
    }
}
export function cookieOptions() {
    const isProd = process.env.NODE_ENV === 'production';
    return {
        httpOnly: true,
        secure: isProd,
        sameSite: isProd ? 'strict' : 'lax',
        path: '/',
        maxAge: 7 * 24 * 60 * 60 * 1000, // 7 days
    };
}
