import nodemailer from 'nodemailer';
export class NodemailerProvider {
    constructor(config, defaultFrom) {
        this.transporter = nodemailer.createTransport({
            host: config.host,
            port: config.port,
            secure: config.secure,
            auth: config.user || config.pass ? { user: config.user, pass: config.pass } : undefined,
        });
        this.defaultFrom = defaultFrom;
    }
    async send(params) {
        const info = await this.transporter.sendMail({
            from: params.from || this.defaultFrom,
            to: params.to,
            subject: params.subject,
            text: params.text,
            html: params.html,
        });
        return { id: info.messageId };
    }
}
