import 'dotenv/config';
import fs from 'fs';
import path from 'path';
import mysql from 'mysql2/promise';
async function run() {
    const conn = await mysql.createConnection({
        host: process.env.DB_HOST || 'localhost',
        user: process.env.DB_USER || 'root',
        password: process.env.DB_PASSWORD || '!Dan2505',
        database: process.env.DB_NAME || 'crypto_wallet',
        multipleStatements: true,
        namedPlaceholders: true,
    });
    const dir = path.resolve(process.cwd(), 'migrations');
    const files = fs.readdirSync(dir)
        .filter(f => f.endsWith('.sql'))
        .sort();
    for (const file of files) {
        const sql = fs.readFileSync(path.join(dir, file), 'utf8');
        process.stdout.write(`Applying migration ${file}...\n`);
        await conn.query(sql);
    }
    await conn.end();
    console.log('Migrations applied successfully.');
}
run().catch(err => {
    console.error(err);
    process.exit(1);
});
