import 'dotenv/config';
export function getEmailConfig() {
    const provider = process.env.EMAIL_PROVIDER || 'nodemailer';
    const fallbackProvider = process.env.EMAIL_FALLBACK_PROVIDER || undefined;
    const from = process.env.EMAIL_FROM || 'No Reply <no-reply@example.com>';
    const appBaseUrl = process.env.APP_BASE_URL || process.env.CLIENT_ORIGIN || 'http://localhost:3000';
    const disableSend = String(process.env.EMAIL_DISABLE_SEND || '').toLowerCase() === 'true';
    const smtp = process.env.SMTP_HOST
        ? {
            host: process.env.SMTP_HOST,
            port: Number(process.env.SMTP_PORT || 587),
            secure: String(process.env.SMTP_SECURE || '').toLowerCase() === 'true',
            user: process.env.SMTP_USER || '',
            pass: process.env.SMTP_PASS || '',
        }
        : undefined;
    const mailgun = process.env.MAILGUN_API_KEY && process.env.MAILGUN_DOMAIN
        ? {
            apiKey: process.env.MAILGUN_API_KEY,
            domain: process.env.MAILGUN_DOMAIN,
            baseUrl: process.env.MAILGUN_BASE_URL || undefined,
            fromOverride: process.env.MAILGUN_FROM || undefined,
        }
        : undefined;
    return { provider, fallbackProvider, from, appBaseUrl, disableSend, smtp, mailgun };
}
